
#ifndef _IMAGE_SPLITTER_H_
#define _IMAGE_SPLITTER_H_

#define PANE_ROW_COL_LIST		0,0
#define PANE_ROW_COL_PAGE		0,1

class GridTest	: public GridTreeControl
{
public:
	void Init(int nID, WndContainer& dlg)
	{
		GridTreeControl::Init(nID, dlg);
		
		m_flx.SelectionMode = flexSelectionByRow;
	}
	
	void ShowGraphList()
	{
		int		index = 0;		
		foreach(PageBase pgbase in Project.Pages)
		{
			if(EXIST_MATRIX == pgbase.GetType())
			{
				index++;
				TreeNode trN = m_trList.AddNode("Row"+index);
				trN.SetAttribute(STR_LABEL_ATTRIB, pgbase.GetName());				
			}
		}
		AddTreeNodes(m_trList, 0, NULL, -1, NULL, true, 0);	
		
		if( index > 0 )
			SelRow(0); // select first row
	}
	
	string GetSelectedMatrix()
	{
		string str;
		TreeNode trN = tree_get_node(m_trList, GetSelectedRow());
		if(trN)
		{
			trN.GetAttribute(STR_LABEL_ATTRIB, str);
		}
		return str;
	}

private:
	Tree	m_trList;
};


class MatrixImageSplitter : public SplitterControl
{
public:
	MatrixImageSplitter();
	~MatrixImageSplitter();
	
	void Init(int nCntrlID, WndContainer& wndParent, int nIndex = 0, LPCSTR lpcszDlgName = NULL)
	{
		SetGridSize(1,2);

		m_IDTreePane = GetDlgCtrlID(PANE_ROW_COL_LIST);
		m_IDPagePane = GetDlgCtrlID(PANE_ROW_COL_PAGE);
		
		InitMsgMap();
		SplitterControl::Init(nCntrlID, wndParent, 1, lpcszDlgName);// 1 = 2nd splitter in dialog
	}

protected:

EVENTS_BEGIN
	ON_INIT(OnInitSplitter)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnResize)
	ON_GRID_ROW_COL_CHANGE(m_IDTreePane, OnRowChange)
EVENTS_END

	BOOL OnInitSplitter();
	BOOL OnDestroy();
	BOOL OnResize(int nType, int cx, int cy);
	BOOL OnRowChange(Control ctrl);

private:
	bool updatePreview(const MatrixLayer& ml);
	bool updatePreview(LPCSTR lpcszMatrix);

private:
	int					m_IDTreePane;
	int					m_IDPagePane;
	PictureControl		m_picCtrl;
	GridTest			m_grid;
}; 
#endif //_IMAGE_SPLITTER_H_